//
//  MCStackBrowseDetailView.h
//  MCApplication
//
//  Created by Ali Lalani on 8/28/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import "MCStackBodyTabView.h"
#import "NSSplitView+ExposePrivate.h"
#import "MCStackTabbedPaneTabProtocol.h"
#import "MCNibLoader.h"
#import "MCDisplayStateProtocol.h"

@class MCSearchField,MCArrayController,MCTableView,MCLinkListView;

@interface MCStackBrowseDetailView : NSSplitView <MCStackTabbedPaneTab,MCDisplayState,MCNibDerivedView>{
	IBOutlet MCTableView *resultsTable;
	BOOL allowsResizing;
	
	// OUTLETS //
	IBOutlet NSView *resultsView;
	IBOutlet MCLinkListView *linkedView;
	IBOutlet NSView *detailView;
	IBOutlet MCSearchField  *searchField;

	NSTableColumn *sortDescriptorImageColumn;

	NSArray *topLevelObjects;

	NSArray *results;
	
	id parentController; // the results pane

	NSMutableDictionary *displayState;
	id                   displayStateDelegate;

	id document;

	NSString *columnConfigIdentifier;
}
- (void)tile;
- (void)setupForDualPane;
- (void)setupForTriPane;

///////////////////////////////////// ACTIONS ////////////////////////////////////////


///////////////////////////////////// ACCESSORS //////////////////////////////////////
- (void)setAllowsResizing:(BOOL)flag;
- (BOOL)allowsResizing;

- (MCArrayController *)resultsController;

//- (void)updateForNewSortDescriptors;

// main active results table
- (id)activeResultsTable;

#pragma mark Accessors
- (id)parentController;
- (void)setParentController:(id)aParentController;

- (id)document;
- (void)setDocument:(id)aDocument;

- (NSArray *)topLevelObjects;
- (void)setTopLevelObjects:(NSArray *)aTopLevelObjects;

- (NSString *)columnConfigIdentifier;
- (void)setColumnConfigIdentifier:(NSString *)aColumnConfigIdentifier;

- (NSTableColumn *)sortDescriptorImageColumn;
- (void)setSortDescriptorImageColumn:(NSTableColumn *)aSortDescriptorImageColumn;

#pragma mark DisplayStateReadWrite
- (void)readLinkedButtonsFromDisplayState;
- (void)writeLinkedButtonsToDisplayState;

- (void)readSearchFieldStringFromDisplayState;
- (void)writeSearchFieldStringToDisplayState;

- (void)readLinkedListSelectedResultsFromDisplayState;
- (void)writeLinkedListSelectedResultsToDisplayState;
@end
